#coding:utf-8

import platform

class quickSdkAsy:

	def getByte(self, data):		
		ver = platform.python_version()
		if (ver[0] == "3"):
			return list(bytes(data, 'utf-8'))
		else:		      
			tmp = [];
			for s in data:
				tmp.append(ord(s));
			return tmp;
		
	def getChars(self, byte):
		ver = platform.python_version()
		if(ver[0] == "3"):
			return str(bytes(byte), "utf-8");			
		else:
			tmpstr = "";
			for n in byte:
				tmpstr += chr(n);
			return tmpstr;
		
	def encryptData(self, data, keys):
		tmpList = [];
		dataArr = self.getByte(data);
		keyArr = self.getByte(keys);
		keyLen = len(keyArr);
		for index,value in enumerate(dataArr):
			tmpList.append(str((0xFF & value) + (0xFF & keyArr[index % keyLen])));
		return "@" + "@".join(tmpList);
	
	def decryptData(self, data, keys):
		tmpList = [];
		dataArr = data.split("@");
		del(dataArr[0]);
		keyArr = self.getByte(keys);
		keyLen = len(keyArr);
		for index,value in enumerate(dataArr):
			tmpList.append(int(value) - (0xFF & keyArr[index % keyLen]) );
		return self.getChars(tmpList);
		
		
#example

data = '#test %data _code$@这是一个简单的测试示例===*******~！@#￥%……&*（）——+';
key = 'test! key';
cc = quickSdkAsy();
endata = cc.encryptData(data, key);
print (endata);
dedata = cc.decryptData(endata, key)
print (dedata);